/*
 * Decompiled with CFR 0.152.
 */
package qouteall.imm_ptl.core.render;

import java.util.Comparator;
import net.minecraft.client.Minecraft;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;
import qouteall.imm_ptl.core.CHelper;
import qouteall.imm_ptl.core.IPCGlobal;
import qouteall.imm_ptl.core.compat.iris_compatibility.IrisInterface;
import qouteall.imm_ptl.core.portal.Portal;
import qouteall.imm_ptl.core.render.TransformationManager;
import qouteall.imm_ptl.core.render.context_management.PortalRendering;
import qouteall.q_misc_util.my_util.BoxPredicate;

@OnlyIn(value=Dist.CLIENT)
public class FrustumCuller {
    private BoxPredicate canDetermineInvisibleFunc;
    private double camX;
    private double camY;
    private double camZ;

    public void update(double cameraX, double cameraY, double cameraZ) {
        this.canDetermineInvisibleFunc = this.getCanDetermineInvisibleFunc(cameraX, cameraY, cameraZ);
        this.camX = cameraX;
        this.camY = cameraY;
        this.camZ = cameraZ;
    }

    public boolean canDetermineInvisibleWithCameraCoord(double minX, double minY, double minZ, double maxX, double maxY, double maxZ) {
        return this.canDetermineInvisibleFunc.test(minX, minY, minZ, maxX, maxY, maxZ);
    }

    public boolean canDetermineInvisibleWithWorldCoord(double minX, double minY, double minZ, double maxX, double maxY, double maxZ) {
        return this.canDetermineInvisibleWithCameraCoord(minX - this.camX, minY - this.camY, minZ - this.camZ, maxX - this.camX, maxY - this.camY, maxZ - this.camZ);
    }

    private BoxPredicate getCanDetermineInvisibleFunc(double cameraX, double cameraY, double cameraZ) {
        if (!IPCGlobal.doUseAdvancedFrustumCulling) {
            return BoxPredicate.nonePredicate;
        }
        if (IrisInterface.invoker.isRenderingShadowMap()) {
            return BoxPredicate.nonePredicate;
        }
        if (PortalRendering.isRendering()) {
            return PortalRendering.getRenderingPortal().getInnerFrustumCullingFunc(cameraX, cameraY, cameraZ);
        }
        if (!IPCGlobal.useSuperAdvancedFrustumCulling) {
            return BoxPredicate.nonePredicate;
        }
        Portal portal = FrustumCuller.getCurrentNearestVisibleCullablePortal();
        if (portal != null) {
            Vec3 portalOrigin = portal.getOriginPos();
            Vec3 portalOriginInLocalCoordinate = portalOrigin.m_82520_(-cameraX, -cameraY, -cameraZ);
            Vec3[] outerFrustumCullingVertices = portal.getOuterFrustumCullingVertices();
            if (outerFrustumCullingVertices == null) {
                return BoxPredicate.nonePredicate;
            }
            Vec3[] downLeftUpRightPlaneNormals = FrustumCuller.getDownLeftUpRightPlaneNormals(portalOriginInLocalCoordinate, outerFrustumCullingVertices);
            Vec3 downPlane = downLeftUpRightPlaneNormals[0];
            Vec3 leftPlane = downLeftUpRightPlaneNormals[1];
            Vec3 upPlane = downLeftUpRightPlaneNormals[2];
            Vec3 rightPlane = downLeftUpRightPlaneNormals[3];
            Vec3 nearPlanePosInLocalCoordinate = portalOriginInLocalCoordinate;
            Vec3 nearPlaneNormal = portal.getNormal().m_82490_(-1.0);
            return (minX, minY, minZ, maxX, maxY, maxZ) -> {
                boolean isBehindNearPlane;
                boolean bl = isBehindNearPlane = FrustumCuller.testBoxTwoVertices(minX, minY, minZ, maxX, maxY, maxZ, nearPlaneNormal.f_82479_, nearPlaneNormal.f_82480_, nearPlaneNormal.f_82481_, nearPlanePosInLocalCoordinate.f_82479_, nearPlanePosInLocalCoordinate.f_82480_, nearPlanePosInLocalCoordinate.f_82481_) == BatchTestResult.all_true;
                if (!isBehindNearPlane) {
                    return false;
                }
                boolean fullyInFrustum = FrustumCuller.isFullyInFrustum(minX, minY, minZ, maxX, maxY, maxZ, leftPlane, rightPlane, upPlane, downPlane);
                return fullyInFrustum;
            };
        }
        return BoxPredicate.nonePredicate;
    }

    public static Vec3[] getDownLeftUpRightPlaneNormals(Vec3 portalOriginInLocalCoordinate, Vec3[] fourVertices) {
        Vec3[] relativeVertices = new Vec3[]{fourVertices[0].m_82549_(portalOriginInLocalCoordinate), fourVertices[1].m_82549_(portalOriginInLocalCoordinate), fourVertices[2].m_82549_(portalOriginInLocalCoordinate), fourVertices[3].m_82549_(portalOriginInLocalCoordinate)};
        return new Vec3[]{relativeVertices[0].m_82537_(relativeVertices[1]), relativeVertices[1].m_82537_(relativeVertices[3]), relativeVertices[3].m_82537_(relativeVertices[2]), relativeVertices[2].m_82537_(relativeVertices[0])};
    }

    public static BatchTestResult testBoxTwoVertices(double minX, double minY, double minZ, double maxX, double maxY, double maxZ, double planeNormalX, double planeNormalY, double planeNormalZ, double planePosX, double planePosY, double planePosZ) {
        double p2z;
        double p1z;
        double p2y;
        double p1y;
        double p2x;
        double p1x;
        if (planeNormalX > 0.0) {
            p1x = minX;
            p2x = maxX;
        } else {
            p1x = maxX;
            p2x = minX;
        }
        if (planeNormalY > 0.0) {
            p1y = minY;
            p2y = maxY;
        } else {
            p1y = maxY;
            p2y = minY;
        }
        if (planeNormalZ > 0.0) {
            p1z = minZ;
            p2z = maxZ;
        } else {
            p1z = maxZ;
            p2z = minZ;
        }
        boolean r1 = FrustumCuller.isInFrontOf(p1x - planePosX, p1y - planePosY, p1z - planePosZ, planeNormalX, planeNormalY, planeNormalZ);
        boolean r2 = FrustumCuller.isInFrontOf(p2x - planePosX, p2y - planePosY, p2z - planePosZ, planeNormalX, planeNormalY, planeNormalZ);
        if (r1 && r2) {
            return BatchTestResult.all_true;
        }
        if (!r1 && !r2) {
            return BatchTestResult.all_false;
        }
        return BatchTestResult.both;
    }

    public static BatchTestResult testBoxTwoVertices(double minX, double minY, double minZ, double maxX, double maxY, double maxZ, Vec3 planeNormal) {
        return FrustumCuller.testBoxTwoVertices(minX, minY, minZ, maxX, maxY, maxZ, planeNormal.f_82479_, planeNormal.f_82480_, planeNormal.f_82481_, 0.0, 0.0, 0.0);
    }

    private static boolean isInFrontOf(double x, double y, double z, Vec3 planeNormal) {
        return x * planeNormal.f_82479_ + y * planeNormal.f_82480_ + z * planeNormal.f_82481_ >= 0.0;
    }

    private static boolean isInFrontOf(double x, double y, double z, double planeNormalX, double planeNormalY, double planeNormalZ) {
        return x * planeNormalX + y * planeNormalY + z * planeNormalZ >= 0.0;
    }

    public static boolean isFullyOutsideFrustum(double minX, double minY, double minZ, double maxX, double maxY, double maxZ, Vec3 leftPlane, Vec3 rightPlane, Vec3 upPlane, Vec3 downPlane) {
        BatchTestResult left = FrustumCuller.testBoxTwoVertices(minX, minY, minZ, maxX, maxY, maxZ, leftPlane);
        BatchTestResult right = FrustumCuller.testBoxTwoVertices(minX, minY, minZ, maxX, maxY, maxZ, rightPlane);
        if (left == BatchTestResult.all_false && right == BatchTestResult.all_true) {
            return true;
        }
        if (left == BatchTestResult.all_true && right == BatchTestResult.all_false) {
            return true;
        }
        BatchTestResult up = FrustumCuller.testBoxTwoVertices(minX, minY, minZ, maxX, maxY, maxZ, upPlane);
        BatchTestResult down = FrustumCuller.testBoxTwoVertices(minX, minY, minZ, maxX, maxY, maxZ, downPlane);
        if (up == BatchTestResult.all_false && down == BatchTestResult.all_true) {
            return true;
        }
        return up == BatchTestResult.all_true && down == BatchTestResult.all_false;
    }

    private static boolean isFullyInFrustum(double minX, double minY, double minZ, double maxX, double maxY, double maxZ, Vec3 leftPlane, Vec3 rightPlane, Vec3 upPlane, Vec3 downPlane) {
        return FrustumCuller.testBoxTwoVertices(minX, minY, minZ, maxX, maxY, maxZ, leftPlane) == BatchTestResult.all_true && FrustumCuller.testBoxTwoVertices(minX, minY, minZ, maxX, maxY, maxZ, rightPlane) == BatchTestResult.all_true && FrustumCuller.testBoxTwoVertices(minX, minY, minZ, maxX, maxY, maxZ, upPlane) == BatchTestResult.all_true && FrustumCuller.testBoxTwoVertices(minX, minY, minZ, maxX, maxY, maxZ, downPlane) == BatchTestResult.all_true;
    }

    @Nullable
    private static Portal getCurrentNearestVisibleCullablePortal() {
        if (TransformationManager.isIsometricView) {
            return null;
        }
        Vec3 cameraPos = Minecraft.m_91087_().f_91063_.m_109153_().m_90583_();
        return CHelper.getClientNearbyPortals(16.0).filter(portal -> portal.isInFrontOfPortal(cameraPos)).filter(Portal::canDoOuterFrustumCulling).min(Comparator.comparingDouble(portal -> portal.getDistanceToNearestPointInPortal(cameraPos))).orElse(null);
    }

    public static boolean isTouchingInsideContentArea(Portal renderingPortal, AABB boundingBox) {
        Vec3 planeNormal = renderingPortal.getContentDirection();
        Vec3 planePos = renderingPortal.getDestPos();
        BatchTestResult batchTestResult = FrustumCuller.testBoxTwoVertices(boundingBox.f_82288_, boundingBox.f_82289_, boundingBox.f_82290_, boundingBox.f_82291_, boundingBox.f_82292_, boundingBox.f_82293_, planeNormal.f_82479_, planeNormal.f_82480_, planeNormal.f_82481_, planePos.f_82479_, planePos.f_82480_, planePos.f_82481_);
        return batchTestResult != BatchTestResult.all_false;
    }

    public static enum BatchTestResult {
        all_true,
        all_false,
        both;

    }
}

